
class TrieNode {

    //Constructor, Time O(1), Space O(1)
    constructor(c) {
        this.data = c;
        this.children = new Array(); //List
        this.isEnd = false;
    }

    //find the node by char, the same functionality as children[ch] in array implementation 
    //Time O(k), Space O(1), k is number of children of this node 
    getChild(c) {
        if (this.children != null)
            for (let child of this.children)
                if (child.data == c)
                    return child;
        return null;
    }
}
  
class Trie {

    //Constructor, Time O(1), Space O(1)
    constructor() {
        this.root = new TrieNode('');
    }

    //insert a word into the trie, Time O(s), Space O(s), s is word length
    insert (word) {
        var node = this.root;
        for (let ch of word) {
            if (node.getChild(ch) == null) 
                node.children.push(new TrieNode(ch));           
            node = node.getChild(ch);           
        }
        node.isEnd = true;
    }

    //find all word with given prefix, call recursion function
    //Time O(n), Space O(n), n is number of nodes involved (include prefix and branches)
    autocomplete (prefix) {
        var node = this.root;
        var res = new Array();
        for (let ch of prefix) { //find end of prefix
            node = node.getChild(ch);
            if (node == null)
                return new Array();
        }
        this.helper(node, res, prefix.substring(0, prefix.length-1));
        return res;
    }

    //recursive function called by autocomplete
    //Time O(n), Space O(n), n is number of nodes in branches
    helper (node, res, prefix) {
        if (node.isEnd)
            res.push(prefix + node.data);
        for (let child of node.children) //list
            this.helper(child, res, prefix + node.data);
    }
} 
         
const t = new Trie();           
t.insert("amazon"); 
t.insert("amazon prime"); 
t.insert("amazing"); 			 
t.insert("amazing spider man"); 
t.insert("amazed");   
t.insert("apple");

a = t.autocomplete("amaz");
console.log(a);
